/** @file   menuloadgame.cpp
 * @brief   Implementation of MenuLoadGame - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */
 
#include "menuloadgame.h"
#include "GfxManager.h"
#include "soundsamples.h"
#include "eng2d.h"
using namespace eng2d;
using std::string;

namespace WeWantWar {


const int MenuLoadGame::BACK_TO_MAINMENU;


/** Constructor
 */
MenuLoadGame::MenuLoadGame() :
  MenuPage()

{
  for (int i=0; i < 6; i++) {
    m_slots.push_back( SaveSlot(i) );
  }
}


/** Destructor
 */
MenuLoadGame::~MenuLoadGame()
{
}


/** Updates the levelchange menu
 */
int MenuLoadGame::update()
{
  int ret = MenuPage::NO_PAGE_CHANGE;
  if ( key[MenuPage::s_lastKey] ) {
    return ret;
  }

  MenuPage::s_lastKey = KEY_O;

  if ( key[KEY_UP] ) {
    MenuPage::s_lastKey = KEY_UP;
    MenuPage::m_selection -= 1;
    if ( MenuPage::m_selection < 0 ) {
      MenuPage::m_selection = 6;
    }
    Sound::playSample(SMP_MENUITEM, false);

  } else if ( key[KEY_DOWN] ) {
    MenuPage::s_lastKey = KEY_DOWN;
    MenuPage::m_selection += 1;
    if ( MenuPage::m_selection > 6 ) {
      MenuPage::m_selection = 0;
    }
    Sound::playSample(SMP_MENUITEM, false);

  } else if ( key[KEY_ENTER] ) {
    MenuPage::s_lastKey = KEY_ENTER;
    ret = this->checkEnterKey();

  } else if ( key[KEY_SPACE] ) {
    MenuPage::s_lastKey = KEY_SPACE;
    ret = this->checkEnterKey();

  }
  
  // ESC - key operates as a back.
  if ( key[KEY_ESC] ) {
    MenuPage::s_lastKey = KEY_ESC;
    MenuPage::m_selection = 0;
    ret = this->checkEnterKey();
    
  } else if ( key[KEY_BACKSPACE] ) {
    MenuPage::s_lastKey = KEY_BACKSPACE;
    MenuPage::m_selection = 0;
    ret = this->checkEnterKey();
    
  }
  
  return ret;
}



/** Redraws this menupage
 */
void MenuLoadGame::redraw()
{
  blit( GfxManager::titlePic, Display::buffer, 0,0, 0,0, 640,480 );

  TPrinter out( Display::buffer );
  out.font( GfxManager::titleFont, "dark30" );
  out.pos( 90,220 );
  out.print( "select game to load" );

  char convbuff[8];
  string items[7];
  items[0] = "cancel";
  for (int i=1; i<7; i++) {
    int sn = m_slots.at(i-1).getSlotContent();
    if ( sn < 0 ) {
      items[i] = "empty slot";
    } else {
      items[i] = "level ";
      items[i] += string( itoa(sn+1, convbuff, 10) );
    }
  }

  int x = 170;
  int y = 260;
  for ( int i=0; i < 7; i++ ) {
    if ( MenuPage::m_selection == i ) {
      out.font( GfxManager::titleFont, "menuitems_sel" );
    } else {
      out.font( GfxManager::titleFont, "menuitems" );
    }
    out.pos( x,y );
    out.print( items[i] );
    y += 30;
  }
  
}


/** Returns the index of the selected save slot.
 */
int MenuLoadGame::getSlotIndex() const
{
  return MenuPage::m_selection - 1;
}

/** Checks the enterkey
 */
int MenuLoadGame::checkEnterKey()
{
  Sound::playSample( SMP_MENUSELECT, false );
  int ret = MenuPage::NO_PAGE_CHANGE;
  switch ( MenuPage::m_selection ) {
    case ( BACK_TO_MAINMENU ): {
      ret = MenuPage::PAGE_CHANGE;
      break;
    }
    case (1):
    case (2):
    case (3):
    case (4):
    case (5):
    case (6):
    case (7): {
      if ( m_slots.at(0).getSlotContent() >= 0 ) {
        // Select this
        ret = MenuPage::PAGE_CHANGE;
      }
      break;
    }
    default: {
      break;
    }
  }
  return ret;
}


} // end of namespace
